
/**
 * Title:        FakeRMI implementation<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Joe Schwartz<p>
 * Company:      Alkindi, LLC<p>
 * @author Joe Schwartz
 * @version 1.0
 */
package Alkindi.RMITest;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;

import Alkindi.BusinessServices.ISearchManager;

import Alkindi.BusinessDataTypes.SystemUser;
import Alkindi.BusinessDataTypes.Product;
import Alkindi.BusinessDataTypes.ProductList;



public class SearchManager extends UnicastRemoteObject implements ISearchManager
{

	public SearchManager() throws RemoteException
	{
	}

	/**
	Locates a given SystemUser given a query string.
	@roseuid 399D9AD60157
	*/
	public SystemUser findMember(java.lang.String query) throws RemoteException
	{
		return new BogusSystemUser();
  	}

	/**
	Locates Products given a query string.
	@roseuid 399DB7650196
	*/
	public ProductList search(java.lang.String queryString) throws RemoteException
	{
		return new BogusProductList();
	}

	/**
	Locates Products given a list of keywords.
	@roseuid 39C1445C0148
	*/
	public ProductList simpleSearch(java.lang.String keywords)
	{
		return new BogusProductList();
	}

}